<?php
/**
 * Plugin Name:       Finmo Payments
 * Plugin URI:        https://docs.finmo.net/
 * Description:       Building smarter payments, together.
 * Version:           1.0.0
 * Requires at least: 5.2
 * Requires PHP:      7.2
 * Author:            Finmo
 * Author URI:        https://finmo.net/
 * License:           GPL v3
 * License URI:       https://www.gnu.org/licenses/gpl-3.0.html
 * Text Domain:       finmo-payments
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Constants
define( 'FINMO_PAYMENTS_VERSION', '1.0.0' );
define( 'FINMO_PAYMENTS_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'FINMO_PAYMENTS_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'FINMO_API_BASE_URL', 'https://api.finmo.net' );
define( 'FINMO_CP_BASE_URL', 'https://cp-gtwy.finmo.net' );
define( 'FINMO_PAYMENTS_PLUGIN_NAME', 'wp_finmo_payments' );
define( 'FINMO_PAYMENTS_PLUGIN_FILE_NAME', plugin_basename( __FILE__ ) );

// Load utils first
require_once FINMO_PAYMENTS_PLUGIN_PATH . 'includes/utils/helpers.php';

function finmo_init_gateway_class() {
    if ( ! class_exists( 'WooCommerce' ) ) {
        add_action( 'admin_notices', function () {
            echo '<div class="error"><p><strong>' . __( 'Finmo requires WooCommerce to be installed and active.', 'finmo-payments' ) . '</strong></p></div>';
        });
        return;
    }

    // Core includes
     require_once FINMO_PAYMENTS_PLUGIN_PATH . 'includes/finmo-payments-api.php';
    require_once FINMO_PAYMENTS_PLUGIN_PATH . 'includes/finmo-frontend-styles.php';
    require_once FINMO_PAYMENTS_PLUGIN_PATH . 'includes/wc-finmo-payments.php';

    foreach ( glob( FINMO_PAYMENTS_PLUGIN_PATH . 'includes/*/*.php' ) as $includeFile ) {
        require_once $includeFile;
    }
}
add_action( 'plugins_loaded', 'finmo_init_gateway_class' );

// Register Gateway (Classic Checkout)
function wc_add_finmo_payments_gateway( $methods ) {
    if ( class_exists( 'FinmoPayments_Gateway' ) ) {
        $methods[] = 'FinmoPayments_Gateway';
    }
    return $methods;
}
add_filter( 'woocommerce_payment_gateways', 'wc_add_finmo_payments_gateway' );

// Register Gateway (Block Checkout)
function wc_add_block_checkout_finmo_payments( $payment_method_registry ) {
    if ( class_exists( 'FinmoPayments_Blocks' ) ) {
        $payment_method_registry->register( new FinmoPayments_Blocks() );
    }
}
add_action( 'woocommerce_blocks_payment_method_type_registration', 'wc_add_block_checkout_finmo_payments' );

// Add Settings link
function finmo_plugin_page_settings_links( $actions ) {
    $plugin_setting_link = array(
        '<a href="' . admin_url( 'admin.php?page=wc-settings&tab=checkout&section=finmo_payments' ) . '">Settings</a>',
    );
    return array_merge( $plugin_setting_link, $actions );
}
add_filter( 'plugin_action_links_' . FINMO_PAYMENTS_PLUGIN_FILE_NAME, 'finmo_plugin_page_settings_links' );

